﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductsXCategoryDB
    {
        public static ProductsXCategory GetItem(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
                List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductsXCategoryID", ((productsXCategoryID != Guid.Empty && productsXCategoryID != null) ? productsXCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));

                return SQLHelper.RetrieveObject<ProductsXCategory>("spGetProductsXCategory", parameters);
            
        }

        public static List<ProductsXCategory> GetList(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
               List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductsXCategoryID", ((productsXCategoryID != Guid.Empty && productsXCategoryID != null) ? productsXCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));

                return SQLHelper.RetrieveList<ProductsXCategory>("spGetProductsXCategory", parameters);
            
        }

        public static DataTable GetDataTable(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductsXCategoryID", ((productsXCategoryID != Guid.Empty && productsXCategoryID != null) ? productsXCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));

                return SQLHelper.ExecuteDataTable("spGetProductsXCategory", parameters);
            
        }

        public static DataSet GetDataSet(Guid productsXCategoryID, Guid productsID, Guid productCategoryID)
        {
            
                List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductsXCategoryID", ((productsXCategoryID != Guid.Empty && productsXCategoryID != null) ? productsXCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));

                return SQLHelper.ExecuteDataSet("spGetProductsXCategory", parameters);
            
        }

        public static void Save(ProductsXCategory myProductCategory)
        {
            myProductCategory.Mode = ((myProductCategory.UniqueID != Guid.Empty && myProductCategory.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductCategory.UniqueID = ((myProductCategory.UniqueID != Guid.Empty && myProductCategory.UniqueID != null) ? myProductCategory.UniqueID : Guid.NewGuid());
            if (myProductCategory.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductCategory.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

                parameters.Add(new SqlParameter("@ProductsXCategoryID", myProductCategory.UniqueID));
                parameters.Add(new SqlParameter("@ProductsID", ((myProductCategory.ProductsID != Guid.Empty && myProductCategory.ProductsID != null) ? myProductCategory.ProductsID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((myProductCategory.ProductCategoryID != Guid.Empty && myProductCategory.ProductCategoryID != null) ? myProductCategory.ProductCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@CreatedBy", ((myProductCategory.UserAccountID != Guid.Empty && myProductCategory.UserAccountID != null) ? myProductCategory.UserAccountID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@IsActive", myProductCategory.IsActive));
                //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
                parameters.Add(new SqlParameter("@Mode", myProductCategory.Mode));

                SQLHelper.ExecuteQuery("spAddOrUpdateProductsXCategory", parameters);
           
        }
    }
}
